/*
 * Created on Jul 8, 2003
 */
package Validators;

import Data.*;

/**
 * This class is being used for validating User data
 * 
 */
public class UserValidator {

	private String message;

	/**
	 * This method is being used to get the validation message
	 * @return String message
	 */
	public String getMessage() {
		return message;
	}
	/**
	 * This method is being used setting validation message
	 * @param String message 
	 * @return void
	 */
	public void setMessage(String message) {
		this.message = message;
	}

	/**
	 * This method is being used to validate user data
	 * @param announcementData data to be validated
	 * @return boolean true if validation successful
	 */
	public boolean validate(UserData userData) {

		UserData userdata = userData;
		String uName, fName, lName, contactNumber, emailAddress, mobileNumber;

		uName = userdata.getLoginId();
		fName = userdata.getFName();
		lName = userdata.getLName();
		contactNumber = userdata.getContactNumber();
		emailAddress = userdata.getEmailAddress();
		mobileNumber = userdata.getMobileNumber();


		if (fName.equals("") || lName.equals("") || uName.equals("")) {
			message = " Enter the required details. ";
			return false;
		}
		if (!uName.matches("^[a-zA-Z/`/'/s/ ]{1,20}+$")) {
			message += " Username should  be less than 10 characters. ";
			return false;
		}
		if (contactNumber.equals("")) {
			message = "Contact Number is empty. ";
			return false;
		}
		if (!fName.matches("^[a-zA-Z/`/'/s/ ]{1,50}+$")) {
			message = "First name has invalid characters.";
			message += " First name has to be less than 50 characters. ";
			return false;
		}
		if (!lName.matches("^[a-zA-Z/`/'/s/ ]{1,50}+$")) {
			message = "Last name has invalid characters.";
			message += " Last name has to be less than 50 characters. ";
			return false;
		}
		if (!contactNumber.matches("^[/(/)0-9/s/ ]{7,12}+$")) {
			message = "Phone number has invalid characters.";
			message += " Phone number must be between 7 and 12 digits long";
			return false;

		}
		if (!mobileNumber.matches("^[/(/)0-9/s/ ]{7,12}+$")) {
			message = "Phone number has invalid characters.";
			message += " Phone number must be between 7 and 12 digits long";
			return false;

		}
		if (!validEmail(emailAddress)) {
			message = "The email address is invalid.";
			return false;
		}

		return true;

	}
	/**
	 * This method is being used for validating email address
	 * @param strEmailAddress email string to be validated
	 * @return boolean true if validation successful
	 */
	private boolean validEmail(String strEmailAddress) {

		boolean bValid = true;

		// return false if strEmailAddress is either null or empty
		if (isNullorEmpty(strEmailAddress)) {
			setMessage("Email address is empty.");
			return false;
		}

		// calculate length of the email address
		int iLength = strEmailAddress.length();

		// get the first occurrence of @ char
		int iCharAtPosition = strEmailAddress.indexOf("@");

		// validation fails if @ character is not present 
		if (iCharAtPosition == -1) {
			setMessage("@ character is not found in Email address.");
			bValid = false;
		}
		// validation fails if @ character found is in the first or last position
		else if (
			(iCharAtPosition == 0) || (iCharAtPosition == (iLength - 1))) {
			setMessage("@ character is not allowed to be in the first or last position in Email address.");
			bValid = false;
		}
		// validation fails if more than 1 @ character are present 
		else if (strEmailAddress.indexOf("@", iCharAtPosition + 1) > -1) {
			setMessage("More than 1 @ characters are not allowed in Email address.");
			bValid = false;
		} else {

			// traverse thru all the characters in the given email address
			for (int i = 0; i < iLength; i++) {

				// get the character at the i position
				char c = strEmailAddress.charAt(i);

				if (c == '.') {
					// validation fails if . character found is in the first or last position
					if ((i == 0) || (i == (iLength - 1))) {
						setMessage(". character is not allowed in the first or the last postion in Email address.");
						bValid = false;
						break;
					}
					// . character cannot come before @ character
					else if (i == (iCharAtPosition - 1)) {
						setMessage(". character cannot immediately precede @ character in Email address.");
						bValid = false;
						break;
					}
				}
				// all these are invalid characters
				else if (
					c > '~'
						|| c < '!'
						|| c == '('
						|| c == ')'
						|| c == '<'
						|| c == '>'
						|| c == '['
						|| c == ']'
						|| c == ','
						|| c == ';'
						|| c == ':'
						|| c == '\\'
						|| c == '"') {
					setMessage(
						"Invalid character " + c + " found in Email address.");
					bValid = false;
					break;
				}
			}
		}
		// return the validation flag 
		return bValid;
	}
	/**
	 * This method is being used to check if the string is null or empty
	 * @param s string to check
	 * @return boolean true if null or empty.
	 */
	private static boolean isNullorEmpty(String s) {
		if (s == null || s.length() == 0) {
			return true;
		}
		return false;
	}

}
